exports.config = {
  output: './output',
  helpers: {
    Puppeteer: {
      url: 'http://localhost:4200/',
      show: false,
      windowSize: '1200x900'
    },
    REST: {
      endpoint: "http://127.0.0.1:8000/api/v1/",
      defaultHeaders: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
      },
    }
  },
  include: {
    I: './steps_file.js'
  },
  mocha: {},
  bootstrap: null,
  teardown: null,
  hooks: [],
  gherkin: {
    features: './features/*.feature',
    steps: ['./step_definitions/steps.js']
  },
  plugins: {
    screenshotOnFail: {
      enabled: true
    },
    pauseOnFail: {},
    retryFailedStep: {
      enabled: true
    },
    tryTo: {
      enabled: true
    }
  },
  tests: './*_test.js',
  name: 'attractor-crm-tests',
  translation: 'ru-RU'
}