import {FETCH_ERROR, FETCH_REQUEST, FETCH_SUCCESS} from "./actionsType";

const initialState = {
  loading: false,
  error: null,
  contacts: {}
};

const reducer = (state = initialState, action) => {
  switch (action.type) {
    case FETCH_REQUEST:
      return {...state, loading: true};
    case FETCH_SUCCESS:
      return {...state, loading: false, contacts: action.contacts};
    case FETCH_ERROR:
      return {...state, loading: false, error: action.error};
    default:
      return state;
  }
};

export default reducer