import axios from '../axios-contacts';
import {FETCH_ERROR, FETCH_REQUEST, FETCH_SUCCESS} from "./actionsType";


export const fetchContactsRequest = () => {
  return {type: FETCH_REQUEST};
};

export const fetchContactsSuccess = contacts => {
  return {type: FETCH_SUCCESS, contacts};
};

export const fetchContactsError = error => {
  return {type: FETCH_ERROR, error};
};


export const getContacts = () => {
  return dispatch => {
    dispatch(fetchContactsRequest());
    axios.get('/contacts.json')
      .then(res => {
        let contacts = res.data;
        dispatch(fetchContactsSuccess(contacts));
      }, err => {
        dispatch(fetchContactsError(err));
      });
  };
};