import React from 'react';
import {StyleSheet, Image, Text, TouchableHighlight, View} from "react-native";

const FullContact = props => {
    return (
        <View style={{marginTop: 22,  flex: 1}}>
            <View>
                <Image source={{uri: props.contact.photo}} style={styles.image}/>
                <Text style={styles.contactProps}>Name: {props.contact.name}</Text>
                <Text style={styles.contactProps}>Mail: {props.contact.email}</Text>
                <Text style={styles.contactProps}>Phone: {props.contact.phone}</Text>
            </View>
            <TouchableHighlight
                onPress={props.closeModal}
                style={styles.btn}>
                <Text style={styles.text}>Hide Modal</Text>
            </TouchableHighlight>
        </View>
    );
};

export default FullContact;


const styles = StyleSheet.create({
    image: {
        width: 200,
        height: 200,
        marginRight: 10
    },
    btn: {
        position: 'absolute',
        bottom: 0,
        padding: 20,
        borderRadius: 5,
        backgroundColor: 'rgba(0,0,0,0.7)',
        width: '100%'
    },
    contactProps: {
        fontWeight: 'bold',
        fontSize: 18,
        marginTop: 10,

    },
    text: {
        fontSize: 24,
        textAlign: 'center',
        color: 'white'
    }
});