import React from 'react';
import {Provider} from "react-redux";
import Main from "./containers/Main/Main";
import {applyMiddleware, compose, createStore} from "redux";
import thunk from "redux-thunk";
import reducer from "./store/reducer";

const composeEnhancers = window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || compose;

const store = createStore(
    reducer,
    composeEnhancers(applyMiddleware(thunk))
);


export default function App() {
  return (
      <Provider store={store}>
        <Main/>
      </Provider>
  );
}

