import React, {Component} from 'react';
import {StyleSheet, Modal, View, Text, FlatList} from "react-native";
import {connect} from "react-redux";
import {getContacts} from "../../store/actions";
import Contact from "../../components/Contact/Contact";
import ContactInfo from "../../components/FullContact/FullContact";

class Main extends Component {
    state = {
        modalShow: false,
        contact: {}
    };

    componentDidMount() {
        this.props.getContacts();
    }

    setModalShow(val) {
        this.setState({modalShow: val});
    }

    chooseContact = (contact) => {
        this.setState({contact, modalShow: true});
    };

    render() {
        let contacts = [];
        for (let contact in this.props.contacts) {
            contacts.push(
                {
                    name: this.props.contacts[contact].name,
                    photo: this.props.contacts[contact].photo,
                    email: this.props.contacts[contact].email,
                    phone: this.props.contacts[contact].phone,
                    id: contact
                })
        }
        return (
            <View style={styles.main}>
                <Modal
                    animationType="slide"
                    transparent={false}
                    visible={this.state.modalShow}
                    onRequestClose={() => {
                        this.setModalShow(!this.state.modalShow);
                    }}>
                    <ContactInfo
                        contact={this.state.contact}
                        closeModal={() => this.setState({modalShow: false})}
                    />
                </Modal>
                <Text style={styles.title}>
                    Contacts
                </Text>
                <FlatList
                    data={contacts}
                    renderItem={contact => (
                        <Contact
                            photo={contact.item.photo}
                            name={contact.item.name}
                            showContact={() => this.chooseContact(contact.item)}/>)}
                    keyExtractor={contact => contact.id}
                />
            </View>
        );
    }
}

const mapStateToProps = state => {
    return {
        contacts: state.contacts
    };
};

const mapDispatchToProps = dispatch => {
    return {
        getContacts: () => dispatch(getContacts())
    };
};

export default connect(mapStateToProps, mapDispatchToProps)(Main);
const styles = StyleSheet.create({
    title: {
        fontSize: 30,
        textTransform: 'uppercase',
        marginBottom: 20
    },
    main: {
        backgroundColor: '#ccc',
        flex: 1,
        justifyContent: 'flex-start',
        padding: 40
    }
});