import {FETCH_CONTACTS_ERROR, FETCH_CONTACTS_REQUEST, FETCH_CONTACTS_SUCCESS} from "./actions";

const initialState = {
  loading: false,
  error: null,
  contacts: {}
};

const reducer = (state = initialState, action) => {
  switch (action.type) {
    case FETCH_CONTACTS_REQUEST:
      return {...state, loading: true};
    case FETCH_CONTACTS_SUCCESS:
      return {...state, loading: false, contacts: action.contacts};
    case FETCH_CONTACTS_ERROR:
      return {...state, loading: false, error: action.error};
    default:
      return state;
  }
};

export default reducer