import axios from '../axios-contacts';

export const FETCH_CONTACTS_REQUEST = 'FETCH_CONTACTS_REQUEST';
export const FETCH_CONTACTS_SUCCESS = 'FETCH_CONTACTS_SUCCESS';
export const FETCH_CONTACTS_ERROR = 'FETCH_CONTACTS_ERROR';


export const fetchContactsRequest = () => {
  return {type: FETCH_CONTACTS_REQUEST};
};

export const fetchContactsSuccess = contacts => {
  return {type: FETCH_CONTACTS_SUCCESS, contacts};
};

export const fetchContactsError = error => {
  return {type: FETCH_CONTACTS_ERROR, error};
};


export const getContacts = () => {
  return dispatch => {
    dispatch(fetchContactsRequest());
    axios.get('/contacts.json')
      .then(res => {
        let contacts = res.data;
        dispatch(fetchContactsSuccess(contacts));
      }, err => {
        dispatch(fetchContactsError(err));
      });
  };
};