import React, {Component} from 'react';
import {StyleSheet, Modal, View, Text, FlatList} from "react-native";
import {connect} from "react-redux";
import {getContacts} from "../../store/actions";
import Contact from "../../components/Contact/Contact";


class Main extends Component {
    state = {
        chosenContact: {}
    };

    componentDidMount() {
        this.props.getContacts();
    }

    chooseContact = (contact) => {
        this.setState({chosenContact: contact, modalVisible: true});
    };

    render() {
        let contacts = [];
        for (let contact in this.props.contacts) {
            let contactProps = this.props.contacts[contact];
            contacts.push(
                {
                    id: contact,
                    photo: contactProps.photo,
                    name: contactProps.name,
                    email: contactProps.email,
                    phone: contactProps.phone
                })
        }
        return (
            <View style={styles.main}>
                <Text style={styles.heading}>
                    Contacts
                </Text>
                <FlatList
                    data={contacts}
                    renderItem={contact => (
                        <Contact
                            photo={contact.item.photo}
                            name={contact.item.name}
                            showContact={() => this.chooseContact(contact.item)}/>)}
                    keyExtractor={contact => contact.id}
                />
            </View>
        );
    }
}


const mapStateToProps = state => {
    return {
        contacts: state.contacts
    };
};

const mapDispatchToProps = dispatch => {
    return {
        getContacts: () => dispatch(getContacts())
    };
};

export default connect(mapStateToProps, mapDispatchToProps)(Main);

const styles = StyleSheet.create({
    heading: {
        fontSize: 32,
        borderColor: 'transparent',
        borderStyle: 'solid',
        borderWidth: 2,
        borderBottomColor: 'black',
        marginBottom: 20
    },
    main: {
        height: '100%',
        marginTop: 150,
        padding: 40
    }
});
