import React from 'react'
import {Text, StyleSheet, TouchableOpacity, Image} from "react-native";

const Contact = props => {
  return (
    <TouchableOpacity style={styles.placeItem} onPress={props.showContact}>
      <Image source={{uri: props.photo}} style={styles.image}/>
      <Text style={{textTransform: 'uppercase'}}>{props.name}</Text>
    </TouchableOpacity>
  );
};

export default Contact;

const styles = StyleSheet.create({
  placeItem: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    width: '100%',
    backgroundColor: '#eee',
    marginBottom: 10,
    padding: 10,
    
  },
  image: {
    width: 60,
    height: 60,
    marginRight: 10
  }
});
