import {
    FETCH_DELETE_CONTACT_SUCCESS,
    FETCH_ERROR,
    FETCH_GET_CONTACTS_SUCCESS,
    FETCH_REQUEST,
    FETCH_SUCCESS
} from "./actionTypes";

const initialState = {
    error: null,
    loading: false,
    contacts: {}
};

const reducer = (state = initialState, action) => {
    switch (action.type) {
        case FETCH_REQUEST: {
            return {...state, loading: true}
        }
        case FETCH_ERROR: {
            return {...state, loading: false, error: action.error}
        }
        case FETCH_SUCCESS: {
            return {...state, loading: false}
        }
        case FETCH_GET_CONTACTS_SUCCESS: {
            return {...state, contacts: action.contacts, loading: false}
        }
        case FETCH_DELETE_CONTACT_SUCCESS: {
            let contacts = {...state.contacts}
            delete contacts[action.id]
            return {...state, contacts, loading: false}
        }
        default: {
            return state
        }
    }
};

export default reducer