import React, {Component} from "react";
import {connect} from "react-redux";
import {deleteContact, getContacts} from "../../store/actions";
import Contact from "../../components/Contact/Contact";
import Modal from "../../components/UI/Modal/Modal";
import FullContact from "../../components/FullContact/FullContact";
import Spinner from "../../components/UI/Spinner/Spinner";


class Contacts extends Component {
    state = {
        selectContact: null
    }

    componentDidMount() {
        this.props.getContacts()
    }

    selectHandler = (value) => {
        this.setState({selectContact: value})
    }

    deleteHandler = (id) => {
        this.props.deleteContact(id, this.selectHandler)
    }

    printContacts = () => {
        let contacts = this.props.contacts
        return Object.keys(contacts).map(contact => {
            return <Contact
                select={() => this.selectHandler(contact)}
                name={contacts[contact].name}
                photo={contacts[contact].photo}
                key={contact}/>
        })
    }

    render() {
        return (
            <>
                {this.props.loading? <Spinner/> : null}
                {this.props.contacts ? <div className='Contacts'>{this.printContacts()}</div> : null}
                {
                    this.state.selectContact ?
                        <Modal backdrop={true}>
                            <>
                                <FullContact
                                    name={this.props.contacts[this.state.selectContact].name}
                                    phone={this.props.contacts[this.state.selectContact].phone}
                                    email={this.props.contacts[this.state.selectContact].email}
                                    photo={this.props.contacts[this.state.selectContact].photo}
                                    id={this.state.selectContact}
                                    selectHandler={this.selectHandler}
                                    delete={this.deleteHandler}
                                />
                            </>
                        </Modal>
                        : null
                }
            </>
        );
    }
}

const mapStateToProps = state => {
    return {
        contacts: state.contacts,
        loading: state.loading
    }
};

const mapDispatchToProps = dispatch => {
    return {
        getContacts: () => dispatch(getContacts()),
        deleteContact: (id, selectHandler) => dispatch(deleteContact(id, selectHandler))
    }
};

export default connect(mapStateToProps, mapDispatchToProps)(Contacts);
