import React from 'react';
import {Switch, Route} from "react-router-dom";
import {Container} from "reactstrap";
import './App.css';
import Layout from "../components/Layout/Layout";
import AddContactForm from "./AddContactForm/AddContactForm";
import Contacts from "./Contacts/Contacts";
import EditContactForm from "./EditContactForm/EditContactForm";


function App() {
    return (
        <>
            <Layout>
                <Container>
                    <Switch>
                        <Route path='/' exact component={Contacts}/>
                        <Route path='/contacts' exact component={Contacts}/>
                        <Route path='/add-contact' exact component={AddContactForm}/>
                        <Route path='/contacts/:id/edit' exact component={EditContactForm}/>
                    </Switch>
                </Container>
            </Layout>
        </>
    );
}

export default App;


