import React from 'react';
import {Button, Form, FormGroup, Label, Input} from 'reactstrap';
import {NavLink} from "react-router-dom";

const FormToFill = props => {
    return (
        <Form className='mb-5' onSubmit={props.submit}>
            <FormGroup>
                <Label for="name">Name</Label>
                <Input type="text"
                       required
                       name="name"
                       value={props.name}
                       onChange={props.inputHandler}
                       id="name"
                       placeholder="enter name"/>
            </FormGroup>
            <FormGroup>
                <Label for="phone">Phone</Label>
                <Input type="text"
                       required
                       name="phone"
                       value={props.phone}
                       onChange={props.inputHandler}
                       id="phone"
                       placeholder="enter phone"/>
            </FormGroup>
            <FormGroup>
                <Label for="email">Email</Label>
                <Input type="email"
                       required
                       name="email"
                       value={props.email}
                       onChange={props.inputHandler}
                       id="email"
                       placeholder="enter email"/>
            </FormGroup>
            <FormGroup>
                <Label for="photo">Photo</Label>
                <Input type="text"
                       required
                       name="photo"
                       value={props.photo}
                       onChange={props.inputHandler}
                       id="photo"
                       placeholder="enter url"/>
            </FormGroup>
            {props.photo ?
            <div>
                <h6>Photo preview</h6>
                <img src={props.photo} width='300' className='mb-4' alt="contact"/>
            </div> : null
            }
            <Button color='success' className='mr-3'>Submit</Button>
            <Button color='info' tag={NavLink} to={`/`}>Back to contacts</Button>
        </Form>
    );
}

export default FormToFill;