import React from "react";
import {NavLink} from "react-router-dom";
import {Button} from "reactstrap";

const FullContact = props => {
    return (
        <div className='FullContact d-flex justify-content-around '>
            <div>
                <img src={props.photo} width='220' alt="contact"/>
            </div>
            <div>
                <div> name: {props.name} </div>
                <div> email: {props.email} </div>
                <div> phone: {props.phone} </div>
                <div className='mt-3'>
                <Button color='info' className='mr-3' tag={NavLink} to={`/contacts/${props.id}/edit`}>edit</Button>
                <Button onClick={() => props.selectHandler(null)} className='mr-3' >cancel</Button>
                <Button onClick={() => props.delete(props.id)} color='danger'>delete</Button>
                </div>
            </div>
        </div>
    );
};

export default FullContact;
