import {
    FETCH_DELETE_CONTACT_SUCCESS,
    FETCH_ERROR,
    FETCH_GET_CONTACTS_SUCCESS,
    FETCH_REQUEST, FETCH_SUCCESS
} from "./actionTypes";
import axios from '../axios-contacts'

const fetchRequest = () => {
    return {type: FETCH_REQUEST};
};

const fetchError = error => {
    return {type: FETCH_ERROR, error};
};

const fetchSuccess = () => {
    return {type: FETCH_SUCCESS}
};

const fetchGetContactsSuccess = contacts => {
    return {type: FETCH_GET_CONTACTS_SUCCESS, contacts}
}

const fetchDeleteContactSuccess = id => {
    return {type: FETCH_DELETE_CONTACT_SUCCESS, id}
}

export const createContact = (contact, history) => {
    return dispatch => {
        dispatch(fetchRequest());
        axios.post("/contacts.json", contact)
            .then(() => {
                dispatch(fetchSuccess());
                history.push('/')
            })
            .catch(err => {
                dispatch(fetchError(err));
            });
    }
};

export const getContacts = () => {
    return dispatch => {
        dispatch(fetchRequest());
        axios.get("/contacts.json")
            .then((response) => {
                dispatch(fetchGetContactsSuccess(response.data));
            })
            .catch(err => {
                dispatch(fetchError(err));
            });
    }
}

export const editContact = (id, history, contact) => {
    return dispatch => {
        dispatch(fetchRequest());
        axios.put(`/contacts/${id}.json`, contact)
            .then(() => {
                dispatch(fetchSuccess());
                history.push('/')
            })
            .catch(err => {
                dispatch(fetchError(err));
            });
    }
}

export const deleteContact = (id, selectHandler) =>{
    return dispatch => {
        dispatch(fetchRequest());
        axios.delete(`/contacts/${id}.json`)
            .then(() => {
                selectHandler(null)
                dispatch(fetchDeleteContactSuccess(id));
            })
            .catch(err => {
                dispatch(fetchError(err));
            });
    }
}
