import React, {useEffect, useState} from "react";
import FormToFill from "../../components/FormToFill/FormToFill";
import {editContact} from "../../store/actions";
import {connect} from "react-redux";
import Spinner from "../../components/UI/Spinner/Spinner";


const EditContactForm = props => {
    const [contactInfo, setContactInfo] = useState({
        name: '',
        phone: '',
        email: '',
        photo: ''
    });

    useEffect(() => {
        let id = props.match.params.id
        setContactInfo(props.contacts[id])
    }, [props.match.params.id, props.contacts])

    const inputHandler = (e) => {
        setContactInfo({
            ...contactInfo,
            [e.target.name]: e.target.value
        })
    };

    const editContact = e => {
        e.preventDefault();
        const contact = {
            ...contactInfo
        };
        props.onEditContact(props.match.params.id, props.history, contact)
    };

    return (
        <>
            {props.loading? <Spinner/> : null}
            <h2 className='mb-4'>Edit contact</h2>
            <div>
                <FormToFill
                    inputHandler={inputHandler}
                    name={contactInfo.name}
                    phone={contactInfo.phone}
                    email={contactInfo.email}
                    photo={contactInfo.photo}
                    submit={editContact}
                />
            </div>
        </>
    );
};


const mapStateToProps = state => {
    return {
        contacts: state.contacts,
        loading: state.loading
    }
};

const mapDispatchToProps = dispatch => {
    return {
        onEditContact: (id, history, contact) => dispatch(editContact(id, history, contact))
    }
};

export default connect(mapStateToProps, mapDispatchToProps)(EditContactForm);
