import React, {useState} from "react";
import FormToFill from "../../components/FormToFill/FormToFill";
import {createContact} from "../../store/actions";
import {connect} from "react-redux";
import Spinner from "../../components/UI/Spinner/Spinner";


const AddContactForm = props => {
    const [contactInfo, setContactInfo] = useState({
        name: '',
        phone: '',
        email: '',
        photo: ''
    });

    const inputHandler = (e) => {
        setContactInfo({
            ...contactInfo,
            [e.target.name]: e.target.value
        })
    };

    const addContact = e => {
        e.preventDefault();
        const contact = {
           ...contactInfo
        };
        props.onContactCreated(contact, props.history)
    };

    return (
        <>
            {props.loading? <Spinner/> : null}
            <h2 className='mb-4'>Add new contact</h2>
            <div>
                <FormToFill
                inputHandler={inputHandler}
                name={contactInfo.name}
                phone={contactInfo.phone}
                email={contactInfo.email}
                photo={contactInfo.photo}
                submit={addContact}
                />
            </div>
        </>
    );
};

const mapStateToProps = state => {
    return {
        loading: state.loading
    }
};


const mapDispatchToProps = dispatch => {
    return {
        onContactCreated: (contact, history) => dispatch(createContact(contact, history))
    }
};

export default connect(mapStateToProps, mapDispatchToProps)(AddContactForm);
