import React, {useEffect, useState} from "react";
import axios from '../../axios-quote'
import FormToFill from "../../components/FormToFill/FormToFill";
import Loader from "../../components/UI/Loader/Loader";


const EditForm = props => {
    const [quoteInfo, setQuoteInfo] = useState({
        author: '',
        category: '',
        text: ''
    });

    const [loading, setLoading] = useState(false);

    const startLoading = () => {
        setLoading(true);
    };

    const stopLoading = () => {
        setLoading(false);
    };

    useEffect(() => {
        startLoading();
        axios.get(`quotes/${props.match.params.id}.json`)
            .then(
                response => {
                    setQuoteInfo(response.data);
                }
            )
            .catch(error => {
                console.log(error)
            })
            .finally(stopLoading)
    }, [props.match.params.id]);

    const inputHandler = (e) => {
        setQuoteInfo({
            ...quoteInfo,
            [e.target.name]: e.target.value
        })
    };

    const submitQuote = () => {
        if (!quoteInfo.text || !quoteInfo.category || !quoteInfo.author) {
            alert('все поля должны быть заполнены');
            return
        }

        startLoading();

        axios.put(`quotes/${props.match.params.id}.json`, quoteInfo)
            .then((response) => {
                props.history.push('/');
            })
            .catch(error => {
                stopLoading();
                console.log(error)
            })
    };

    return (
        <div className='QuoteForm'>
            <FormToFill submitQuote={submitQuote}
                        inputHandler={inputHandler}
                        text={quoteInfo.text}
                        category={quoteInfo.category}
                        author={quoteInfo.author}
            />
            {loading ? <Loader/> : null}
        </div>
    )
};


export default EditForm