import React from 'react';
import {Switch, Route} from "react-router-dom";
import {Container} from "reactstrap";
import './App.css';
import AddForm from "./AddForm/AddForm";
import Quotes from "./Quotes/Quotes";
import Header from "../components/Header/Header";
import EditForm from "./EditForm/EditForm";

function App() {
    return (
        <>
            <Header/>
            <Container>
                    <Switch>
                        <Route path="/add-quote" exact component={AddForm}/>
                        <Route path="/" exact component={Quotes}/>
                        <Route path="/quotes/" exact component={Quotes}/>
                        <Route path="/quotes/:id/edit" exact component={EditForm}/>
                        <Route path="/quotes/:category" exact component={Quotes}/>
                    </Switch>
            </Container>
        </>
    );
}

export default App;
