import React from "react";
import {Nav, Navbar, NavItem} from "reactstrap";
import {NavLink} from "react-router-dom";
import CATEGORIES from "../../quotes-categories";

const Sidebar = () => {
    const printCategories = () => {
        return CATEGORIES.map(category => {
            return <NavItem  key={`sidebar_${category.id}` }>
                <NavLink className="nav-link"  to={'/quotes/' + category.id} >{category.title}</NavLink>
            </NavItem>
        })
    };

    return (
        <Navbar light>
        <Nav navbar>
            <NavItem>
                <NavLink className="nav-link font-weight-bold text-uppercase" to="/quotes">All</NavLink>
            </NavItem>
                {printCategories()}
        </Nav>
        </Navbar>
    );
};

export default Sidebar;