import React from "react";
import {Container, Nav, Navbar, NavbarBrand, NavItem} from "reactstrap";
import {NavLink} from "react-router-dom";

const Header = () => {
    return (
        <Navbar color="dark" dark expand="md" className="mb-5">
            <Container>
                <NavbarBrand tag={NavLink} to="/" exact>Quotes Central</NavbarBrand>
                <Nav navbar>
                    <NavItem>
                        <NavLink className="nav-link" to="/quotes">Quotes</NavLink>
                    </NavItem>
                    <NavItem>
                        <NavLink className="nav-link" to="/add-quote">Add new quote</NavLink>
                    </NavItem>
                </Nav>
            </Container>
        </Navbar>
    );
};

export default Header;
