import React, {useEffect, useState} from "react";
import axios from '../../axios-quote'
import FormToFill from "../../components/FormToFill/FormToFill";
import CATEGORIES from "../../quotes-categories";


const QuoteForm = props => {
    const [quoteInfo, setQuoteInfo] = useState({
        author: '',
        category: CATEGORIES[0].id,
        text: ''
    });

    useEffect(() => {
        if (props.match.params.id) {
            axios.get(`quotes/${props.match.params.id}.json`)
                .then(
                    response => {
                        setQuoteInfo(response.data)
                    }
                )
        }
        else{
            let resetQuoteInfo = {
                author: '',
                category: CATEGORIES[0].id,
                text: ''
            };
            setQuoteInfo(resetQuoteInfo)
        }
    },[props.match.params.id]);

    const inputHandler = (e) => {
        setQuoteInfo({
            ...quoteInfo,
            [e.target.name]: e.target.value
        })
    };

    const submitQuote = () => {
        if (!quoteInfo.text || !quoteInfo.category || !quoteInfo.author) {
            alert('все поля должны быть заполнены');
            return
        }

        axios.post('/quotes.json', quoteInfo).then(
            ()=> {
                props.history.push('./')
            }
        )
    };


    return (
        <div className='QuoteForm'>
            <FormToFill submitQuote={submitQuote}
                        inputHandler={inputHandler}
                        text={quoteInfo.text}
                        category={quoteInfo.category}
                        author={quoteInfo.author}
            />
        </div>
    )
};


export default QuoteForm