import React from 'react';
import { Card, Button, CardFooter, CardBody,
    CardTitle, CardText } from 'reactstrap';
import {NavLink} from "react-router-dom";


const Quote = props => {
    return (
        <div className='Quote mb-3'>
            <Card>
                <CardBody>
                    <CardTitle className='text-uppercase font-weight-bold'>{props.author}</CardTitle>
                    <CardText>{props.text}</CardText>
                    <Button onClick={props.delete} className='mr-3' color='danger'>Delete</Button>
                    <Button tag={NavLink} to={`/quotes/${props.id}/edit`} color='info'>Edit</Button>
                </CardBody>
                <CardFooter className='text-muted'>{props.category}</CardFooter>
            </Card>
        </div>
    );
};

export default Quote;