import React, {useEffect, useState} from "react";
import axios from '../../axios-quote'
import Quote from "../../components/Quote/Quote";

const Quotes = () => {

    const [quotes, setQuotes] = useState({});

    useEffect(() => {
        axios.get('/quotes.json').then(
            response => {
                setQuotes(response.data)
            }
        )
    }, []);


    const printQuotes = () => {
        return Object.keys(quotes).map(quote => {
            return <Quote author={quotes[quote].author}
                          text={quotes[quote].text}
                          category={quotes[quote].category}
                          key={quote}
            />
        })
    };

    return (
        <div className='Quotes'>
            {
                Object.keys(quotes).length > 0 ? printQuotes() : 'Please add quotes'
            }
        </div>
    )

};


export default Quotes