import React from 'react';
import {Switch, Route} from "react-router-dom";
import {Container} from "reactstrap";
import './App.css';
import QuoteForm from "./QuoteForm/QuoteForm";
import Quotes from "./Quotes/Quotes";
import Header from "../components/Header/Header";
import Sidebar from "../components/Sidebar/Sidebar";

function App() {
    return (
        <>

            <Header/>
            <Container className='App_wrapper'>
                <div className="App_sidebar">
                    <Sidebar/>
                </div>
                <div className="App_switches">
                    <Switch>
                        <Route path="/add-quote" exact component={QuoteForm}/>
                        <Route path="/" exact component={Quotes}/>
                        <Route path="/quotes/" exact component={Quotes}/>
                        <Route path="/quotes/:category" exact component={Quotes}/>
                    </Switch>
                </div>
            </Container>
        </>
    );
}

export default App;
