import React from 'react';
import { Button, Form, FormGroup, Label, Input, FormText } from 'reactstrap';
import CATEGORIES from "../../quotes-categories";

const FormToFill = (props) => {
    const printOptions = () => {
        return  CATEGORIES.map(category => {
            return <option key={`form-${category.id}`} value={category.id}>{category.title}</option>
        })
    };

    return (
        <Form>
            <FormGroup>
                <Label for="author">Author</Label>
                <Input
                    type="text"
                    name="author"
                    id="author"
                    onChange={props.inputHandler}/>
            </FormGroup>
            <FormGroup>
                <Label for="category">Select</Label>
                <Input
                    type="select"
                    name="category"
                    id="category"
                    onChange={props.inputHandler}>
                    <option   value="" disabled >Select category</option>
                    {printOptions()}
                </Input>
            </FormGroup>
            <FormGroup>
                <Label for="text">Quote Text</Label>
                <Input type="textarea"
                       name="text"
                       id="text"
                       onChange={props.inputHandler}
                />
            </FormGroup>
            <Button onClick={props.submitQuote}>Submit</Button>
        </Form>
    );
};

export default FormToFill;