import React, {useEffect, useState} from "react";
import axios from '../../axios-quote'
import Quote from "../../components/Quote/Quote";
import Loader from "../../components/UI/Loader/Loader";
import Sidebar from "../../components/Sidebar/Sidebar";
import './Quotes.css'

const Quotes = props => {
    const [quotes, setQuotes] = useState({});
    const [loading, setLoading] = useState(false);

    const startLoading = () => {
        setLoading(true);
    };

    const stopLoading = () => {
        setLoading(false);
    };

    useEffect(() => {
            startLoading();
            axios.get(
                props.match.params.category ?
                    `/quotes.json?orderBy="category"&equalTo="${props.match.params.category}"` :
                    '/quotes.json')
                .then(
                    response => {
                        setQuotes(response.data)
                    })
                .catch(error => {
                    console.log(error)
                })
                .finally(stopLoading)
        }
        , [props.match.params.category]);


    const deleteQuote = (id) => {
        startLoading();
        axios.delete(`/quotes/${id}.json`)
            .then(() => {
                let allQuotes = {...quotes};
                delete allQuotes[id];
                setQuotes(allQuotes)
            })
            .catch(error => {
                console.log(error)
            })
            .finally(stopLoading)
    };

    const printQuotes = () => {
        return Object.keys(quotes).map(quote => {
            return <Quote author={quotes[quote].author}
                          text={quotes[quote].text}
                          key={quote}
                          delete={() => deleteQuote(quote)}
                          id={quote}
            />
        })
    };

    return (
        <>
            <div className='Quotes'>
                <div className="Quotes_sidebar">
                    <Sidebar/>
                </div>
                <div className="Quotes_items">
                    {Object.keys(quotes).length > 0 ? printQuotes() : 'Please add quotes'}
                    {loading ? <Loader/> : null}
                </div>
            </div>
        </>
    )

};


export default Quotes