import React, { useState} from "react";
import axios from '../../axios-quote'
import FormToFill from "../../components/FormToFill/FormToFill";
import CATEGORIES from "../../quotes-categories";
import Loader from "../../components/UI/Loader/Loader";


const AddForm = props => {
    const [quoteInfo, setQuoteInfo] = useState({
        author: '',
        category: CATEGORIES[0].id,
        text: ''
    });

    const [loading, setLoading] = useState(false);

    const startLoading = () => {
        setLoading(true);
    };

    const stopLoading = () => {
        setLoading(false);
    };

    const inputHandler = (e) => {
        setQuoteInfo({
            ...quoteInfo,
            [e.target.name]: e.target.value
        })
    };


    const submitQuote = () => {
        if (!quoteInfo.text || !quoteInfo.category || !quoteInfo.author) {
            alert('все поля должны быть заполнены');
            return
        }
         startLoading();

            axios.post('/quotes.json', quoteInfo).then(
                () => {
                    props.history.push('/')
                })
                .catch(error => {
                    console.log(error);
                    stopLoading()
                })
    };

    return (
        <div className='QuoteForm'>
            <FormToFill submitQuote={submitQuote}
                        inputHandler={inputHandler}
                        text={quoteInfo.text}
                        category={quoteInfo.category}
                        author={quoteInfo.author}
            />
            {loading ? <Loader/> : null}

        </div>

    )
};


export default AddForm