import React, {useEffect, useState} from "react";
import axios from '../../axios-quote'
import Quote from "../../components/Quote/Quote";

const Quotes = props => {

    const [quotes, setQuotes] = useState({});

    useEffect(() => {
            axios.get(
                props.match.params.category ?
                    `/quotes.json?orderBy="category"&equalTo="${props.match.params.category}"` :
                    '/quotes.json')
                .then(
                    response => {
                        setQuotes(response.data)
                    })
                .catch(error => {
                    console.log(error)
                })
        }
        , [props.match.params.category]);


    const printQuotes = () => {
        return Object.keys(quotes).map(quote => {
            return <Quote author={quotes[quote].author}
                          text={quotes[quote].text}
                          category={quotes[quote].category}
                          key={quote}
            />
        })
    };

    return (
        <div className='Quotes'>
            {
                Object.keys(quotes).length > 0 ? printQuotes() : 'Please add quotes'
            }
        </div>
    )

};


export default Quotes