import React from 'react';
import { Card, Button, CardFooter, CardBody,
    CardTitle, CardText } from 'reactstrap';

const Quote = props => {
    return (
        <div className='Quote mb-3'>
            <Card>
                <CardBody>
                    <CardTitle className='text-uppercase font-weight-bold'>{props.author}</CardTitle>
                    <CardText>{props.text}</CardText>
                    <Button className='mr-3' color='danger'>Delete</Button>
                    <Button color='info'>Edit</Button>
                </CardBody>
                <CardFooter className='text-muted'>{props.category}</CardFooter>
            </Card>
        </div>
    );
};

export default Quote;