import React, {Component} from 'react';
import './App.css';
import Basket from "../components/Basket/Basket";
import Menu from "../components/Menu/Menu";

class App extends Component {
    state = {
        menu: {
            Hamburger: {
                price: 200,
                type: 'eat'
            },
            Cheeseburger: {
                price: 300,
                type: 'eat'
            },
            Fries: {
                price: 150,
                type: 'eat'
            },
            Coffee: {
                price: 70,
                type: 'drink'
            },
            Tea: {
                price: 50,
                type: 'drink'
            },
            Cola: {
                price: 100,
                type: 'drink'
            }
        },
        totalPrice: 0,
        basket: {}
    };

    addElement = (name) => {
        let basket = {...this.state.basket};

        if (!basket[name]){
            basket[name] = 1
        } else {
            basket[name]++
        }

        let totalPrice = this.state.totalPrice + this.state.menu[name].price;
        this.setState({totalPrice, basket})
    };


    render() {
        return (
            <div className='App'>
                <Basket menuList={this.state.menu} totalPrice={this.state.totalPrice} basket={this.state.basket}/>
                <Menu menuList={this.state.menu} addElement={this.addElement}/>
            </div>
        )
    }
}

export default App;

