import React from "react";
import MenuItem from "./MenuItem/MenuItem";
import './Menu.css'

const Menu = props => {

    let createMenu = () => {
        let menuKeys = Object.keys(props.menuList);
        return menuKeys.map(key => {
            let className = ['MenuItem'];

            if (props.menuList[key].type === 'drink') {
                className.push('MenuItem_drink')
            } else {
                className.push('MenuItem_eat')
            }

            return <MenuItem addElem={() => (props.addElement(key))} name={key} price={props.menuList[key].price}
                             key={'MenuItem-' + key} class={className.join(' ')}/>
        });
    };

    return (
        <div className='Menu'>
            {createMenu()}
        </div>
    );
};

export default Menu;