import React from "react";
import BasketItem from "./BasketItem/BaskeItem";
import TotalPrice from "./TotalPrice/TotalPrice";
import './Basket.css'

const Basket = props => {
    let basketElements = Object.keys(props.basket);
    let emptyBasket = 'Basket empty. Please, add items';

    let createBasket = () => {
        return basketElements.map((elem, i) => {
            return <BasketItem
                key={'BasketItem-' + {elem} + i}
                qty={props.basket[elem]}
                price={props.menuList[elem].price}
                name={elem}/>;
        });
    }
    return (
        <div className='Basket'>
            {basketElements.length > 0 ? createBasket() : emptyBasket}
            {props.totalPrice > 0 ? <TotalPrice totalPrice={props.totalPrice}/> : null}
        </div>
    );
};

export default Basket;