import React from "react";
import MenuItem from "./MenuItem/MenuItem";
import './Menu.css'

const Menu = props => {

    let createMenu = () => {
        let menuKeys = Object.keys(props.menuList);
        return menuKeys.map(key => {
           let imgUrl = './img/drink_icon.jpg';

           if (props.menuList[key].type === 'food') {
               imgUrl = './img/food_icon.jpg';
           }

            return <MenuItem addElem={() => (props.addElement(key))} name={key} price={props.menuList[key].price}
                             key={'MenuItem-' + key} img={imgUrl}/>
        });
    };

    return (
        <div className='Menu'>
            {createMenu()}
        </div>
    );
};

export default Menu;