import {FETCH_CATEGORIES_SUCCESS, FETCH_ERROR} from "../actionTypes";
import axios from "../../axios-api";

const fetchCategoriesSuccess = (categories) => {
    return {type: FETCH_CATEGORIES_SUCCESS, categories};
};
const fetchError = error => {
    return {type: FETCH_ERROR, error};
};

export const fetchCategories = () => {
    return dispatch => {
        axios.get("/categories").then(response => {
            dispatch(fetchCategoriesSuccess(response.data));
        }).catch(e => {
            dispatch(fetchError(e));
        })
    };
};
