import React from "react";
import {Button, Card, CardBody, CardImg, CardText, Col} from "reactstrap";
import {NavLink} from "react-router-dom";
import PropTypes from "prop-types";
import config from "../../config";

const Product = (props) => {
  return (
    <Col md={5} className='mb-3  p-3'>
      <Card className='p-3 h-100'>
        <CardImg top className='w-80' src={config.apiURL + '/uploads/' + props.image} alt="Card image cap" />
        <CardBody>
          <h5 className='mb-0 font-weight-bold'>{props.title}</h5>
          <CardText> price: {props.price}</CardText>
          <Button tag={NavLink} to={/products/ + props.id}>Show product</Button>
        </CardBody>
      </Card>
    </Col>
  );
};

Product.propTypes = {
  id: PropTypes.string.isRequired,
  image: PropTypes.string.isRequired,
  title: PropTypes.string.isRequired,
  price: PropTypes.number.isRequired
};

export default Product;
