import React, {Component, Fragment} from 'react';
import {Container} from "reactstrap";
import {Route, Switch, withRouter} from "react-router-dom";
import {connect} from "react-redux";
import {NotificationContainer} from "react-notifications";
import Toolbar from "../components/UI/Toolbar/Toolbar";
import Products from "./Products/Products";
import Register from "./Register/Register";
import Login from "./Login/Login";
import AddProductForm from "./AddProductForm/AddProductForm";
import {logoutUser} from "../store/actions/usersActions";
import FullProduct from "./FullProduct/FullProduct";


class App extends Component {
    render() {
        return (
            <Fragment>
                <NotificationContainer />
                <header>
                    <Toolbar
                        user={this.props.user}
                        logout={this.props.logoutUser}
                    />
                </header>
                <main>
                    <Container className="mt-5">
                        <Switch>
                            <Route path="/" exact component={Products} />
                            <Route path="/products" exact component={Products} />
                            <Route path="/category/:id" exact component={Products} />
                            <Route path="/register" exact component={Register} />
                            <Route path="/login" exact component={Login} />
                            <Route path="/products/new" exact component={AddProductForm} />
                            <Route path="/products/:id" exact component={FullProduct} />
                        </Switch>
                    </Container>
                </main>
            </Fragment>
        );
    }
}

const mapStateToProps = state => {
    return {
        user: state.users.user
    }
};

const mapDispatchToProps = dispatch => {
    return {
        logoutUser: () => dispatch(logoutUser())
    }
};

export default withRouter(connect(mapStateToProps, mapDispatchToProps)(App));