import React, {Component} from "react";
import {Nav, NavItem, Row} from "reactstrap";
import {connect} from "react-redux";
import {NavLink} from "react-router-dom";
import './Products.css';
import Product from "../../components/Product/Product";
import {fetchCategories} from "../../store/actions/categoriesActions";
import {fetchProducts} from "../../store/actions/productsActions";

class Products extends Component {
    componentDidMount() {
        this.props.onFetchCategories();
        this.props.fetchProducts(this.props.match.params.id)
    }

    componentDidUpdate(prevProps) {
        if (this.props.match.params.id !== prevProps.match.params.id) {
            this.props.fetchProducts(this.props.match.params.id)
        }
    };

    render() {
        return (
            <div className='Products'>
                <Nav navbar c vertical className='Products_categories'>
                    <NavItem>
                        <NavLink to='/'> All items</NavLink>
                    </NavItem>
                    {this.props.categories.map(category => {
                        return (
                            <NavItem key={category._id}>
                                <NavLink to={'/category/' + category._id}>{category.title}</NavLink>
                            </NavItem>)
                    })}
                </Nav>
                <div className='Products_items'>
                    <h3>
                        Products:
                    </h3>
                    <Row>
                        {this.props.products.length > 0 ? (
                            this.props.products.map(product => {
                                return (
                                    <Product key={product._id} id={product._id} image={product.image}
                                             title={product.title}
                                             price={product.price}/>
                                );
                            })) : <h5> No products in this category</h5>
                        }
                    </Row>
                </div>
            </div>
        );
    }
}

const mapStateToProps = state => {
    return {
        categories: state.categories.categories,
        products: state.products.products
    }
};

const mapDispatchToProps = dispatch => {
    return {
        onFetchCategories: () => dispatch(fetchCategories()),
        fetchProducts: (category) => dispatch(fetchProducts(category)),
    }
};

export default connect(mapStateToProps, mapDispatchToProps)(Products);
