import React, {Component} from "react";
import {connect} from "react-redux";
import config from "../../config";
import './FullProduct.css'
import {Badge, Button} from "reactstrap";
import {NavLink} from "react-router-dom";
import {deleteProduct, getFullProduct} from "../../store/actions/productsActions";

class FullProduct extends Component {

    componentDidMount() {
        this.props.getFullProduct(this.props.match.params.id)
    }


    render() {

        return (
            <>

                {(this.props.fullProduct && this.props.fullProduct.author) ? (
                    <>
                        <img width="500" className='postImage'
                             src={config.apiURL + '/uploads/' + this.props.fullProduct.image} alt=""/>
                        <h2>product name: {this.props.fullProduct.title}</h2>
                        <h5>price: {this.props.fullProduct.price} $</h5>
                        <h5> category: {this.props.fullProduct.category.title}</h5>
                        <h5> description: {this.props.fullProduct.description}</h5>
                        <h6 className='mt-3'>author: {this.props.fullProduct.author.displayName}</h6>
                        <h6> phone: {this.props.fullProduct.author.phone}</h6>

                    </>
                ) : null}

                {(this.props.fullProduct && this.props.fullProduct.author && this.props.user && this.props.user.username === this.props.fullProduct.author.username) ? (
                    <Button className='mt-4' color='danger'
                            onClick={() => this.props.deleteProduct(this.props.match.params.id)}>Delete
                        product</Button>) : null}
            </>

        );
    }
}

const mapStateToProps = state => {
    return {
        fullProduct: state.products.fullProduct,
        user: state.users.user
    }
};

const mapDispatchToProps = dispatch => {
    return {
        getFullProduct: (id) => dispatch(getFullProduct(id)),
        deleteProduct: (id) => dispatch(deleteProduct(id))

    }
};

export default connect(mapStateToProps, mapDispatchToProps)(FullProduct);
