import React, {Component} from "react";
import {Button, Col, Form, FormGroup} from "reactstrap";
import {connect} from "react-redux";
import FormElement from "../../components/UI/FormElement/FormElement";
import {registerUser} from "../../store/actions/usersActions";

class Register extends Component {
  state = {
    username: "",
    password: "",
    displayName: "",
    phone: ""
  };

  inputChangeHandler = (e) => {
    this.setState({[e.target.name]: e.target.value});
  };
  formSubmitHandler = (e) => {
    e.preventDefault();
    this.props.onRegisterUser({...this.state});
  };

  getFieldError = fieldName => {
    return this.props.error && this.props.error.errors && this.props.error.errors[fieldName] && this.props.error.errors[fieldName].message;
  };

  render() {
    return (
      <>
        <h2>Register new user</h2>
        <Form onSubmit={this.formSubmitHandler}>
          <FormElement
            propertyName="username"
            label="Username"
            onChange={this.inputChangeHandler}
            value={this.state.username}
            required={true}
            type="text"
            error={this.getFieldError("username")}
          />
          <FormElement
            propertyName="password"
            label="Password"
            onChange={this.inputChangeHandler}
            value={this.state.password}
            required={true}
            type="password"
            error={this.getFieldError("password")}
          />
          <FormElement
            propertyName="displayName"
            label="Display name"
            onChange={this.inputChangeHandler}
            value={this.state.displayName}
            required={true}
            type="text"
            error={this.getFieldError("displayName")}
          />
          <FormElement
            propertyName="phone"
            label="Phone number"
            onChange={this.inputChangeHandler}
            value={this.state.phone}
            required={true}
            type="text"
            error={this.getFieldError("phone")}
          />
          <FormGroup row>
            <Col sm={{offset:2, size: 10}}>
              <Button type="submit" color="primary">
                Register
              </Button>
            </Col>
          </FormGroup>
        </Form>
      </>
    );
  }
}

const mapStateToProps = state => {
  return {
    error: state.users.registerError
  };
};
const mapDispatchToProps = dispatch => {
  return {
    onRegisterUser: userData => dispatch(registerUser(userData))
  };
};

export default connect(mapStateToProps, mapDispatchToProps)(Register);
