import React from "react";
import PropTypes from "prop-types";
import {Col, FormFeedback, FormGroup, Input, Label} from "reactstrap";

const FormElement = props => {
  return (
    <FormGroup row>
      <Label sm={2} for={props.propertyName}>{props.label}</Label>
      <Col sm={10}>
        <Input
          type={props.type}
          required={props.required}
          name={props.propertyName}
          id={props.propertyName}
          value={props.value}
          onChange={props.onChange}
          invalid={!!props.error}
          placeholder={props.placeholder}
          min={props.min}
        />
        {
          props.error &&
          <FormFeedback>
            {props.error}
          </FormFeedback>
        }
      </Col>
    </FormGroup>
  );
};

FormElement.propTypes = {
  propertyName: PropTypes.string.isRequired,
  label: PropTypes.string.isRequired,
  required: PropTypes.bool,
  value: PropTypes.string,
  onChange: PropTypes.func.isRequired,
  error: PropTypes.string,
  type: PropTypes.string
};

export default FormElement;
