import React from 'react';
import {DropdownItem, DropdownMenu, DropdownToggle, NavItem, NavLink, UncontrolledDropdown} from "reactstrap";
import {NavLink as RouterNavLink} from "react-router-dom";

const UserMenu = ({user, logout}) => {
    return (<>
            <NavItem>
                <NavLink tag={RouterNavLink} to="/" exact>
                    Products
                </NavLink>
            </NavItem>
            <NavItem>
                <NavLink tag={RouterNavLink} to="/products/new" exact>Create product</NavLink>
            </NavItem>
            <UncontrolledDropdown className='ml-5' nav navbar inNavbar>
                <DropdownToggle nav caret>
                    Hello, {user.displayName}!
                </DropdownToggle>
                <DropdownMenu right>
                    <DropdownItem divider/>
                    <DropdownItem
                        onClick={logout}>
                        Logout
                    </DropdownItem>
                </DropdownMenu>
            </UncontrolledDropdown> </>
    )
};

export default UserMenu;
