import React from 'react';
import ReactDOM from 'react-dom';
import {Provider} from 'react-redux';
import * as serviceWorker from './serviceWorker';
import "react-notifications/lib/notifications.css"
import 'bootstrap/dist/css/bootstrap.min.css';
import App from './App';
import {store, history} from "./store/configureStore";
import {ConnectedRouter} from "connected-react-router";


const app = (
    <Provider store={store}>
        <ConnectedRouter history={history}>
            <App/>
        </ConnectedRouter>
    </Provider>
);

ReactDOM.render(app, document.getElementById('root'));
serviceWorker.unregister();

