import React from 'react';
import {DropdownItem, DropdownMenu, DropdownToggle, NavItem, NavLink, UncontrolledDropdown} from "reactstrap";
import {NavLink as RouterNavLink} from "react-router-dom";

const UserMenu = ({user, logout}) => {
  return(
    <UncontrolledDropdown nav inNavbar>
      <DropdownToggle nav caret>
        Hello, {user.displayName}!
      </DropdownToggle>
        <NavItem>
            <NavLink tag={RouterNavLink} to="/products" exact>
                Products
            </NavLink>
        </NavItem>
      <DropdownMenu right>
        <DropdownItem>
          <NavLink tag={RouterNavLink} to="/products/new" exact>Create product</NavLink>
        </DropdownItem>
        <DropdownItem divider />
        <DropdownItem
          onClick={logout}>
          Logout
        </DropdownItem>
      </DropdownMenu>
    </UncontrolledDropdown>
)};

export default UserMenu;
