import React, {Component, Fragment} from 'react';
import Toolbar from "./components/UI/Toolbar/Toolbar";
import {Container} from "reactstrap";
import {Route, Switch, withRouter} from "react-router-dom";
import Register from "./containers/Register/Register";
import Login from "./containers/Login/Login";
import {connect} from "react-redux";
import {NotificationContainer} from "react-notifications";
import {logoutUser} from "./store/actions/usersActions";

class App extends Component {
    render() {
        return (
            <Fragment>
                <NotificationContainer />
                <header>
                    <Toolbar
                        user={this.props.user}
                        logout={this.props.logoutUser}
                    />
                </header>
                <main>
                    <Container className="mt-5">
                        <Switch>
                            <Route path="/register" exact component={Register} />
                            <Route path="/login" exact component={Login} />
                        </Switch>
                    </Container>
                </main>
            </Fragment>
        );
    }
}

const mapStateToProps = state => {
    return {
        user: state.users.user
    }
};

const mapDispatchToProps = dispatch => {
    return {
        logoutUser: () => dispatch(logoutUser())
    }
};

export default withRouter(connect(mapStateToProps, mapDispatchToProps)(App));