import {
    FETCH_CATEGORIES_SUCCESS, FETCH_ERROR
} from "../actionTypes";

const initialState = {
    categories: [],
    error: null
};

const categoriesReducer = (state = initialState, action) => {
    switch (action.type) {
        case FETCH_CATEGORIES_SUCCESS:
            return {...state, categories: action.categories};
        case FETCH_ERROR:
            return {...state, error: action.error};
        default:
            return state;
    }
};

export default categoriesReducer;