import {
    FETCH_ERROR, FETCH_PRODUCTS_SUCCESS,
    GET_FULL_PRODUCT_SUCCESS
} from "../actionTypes";

const initialState = {
    fullProduct: {},
    error: null,
    products:[]
};

const productsReducer = (state = initialState, action) => {
    switch (action.type) {
        case GET_FULL_PRODUCT_SUCCESS:
            return {...state, fullProduct: action.product};
        case FETCH_PRODUCTS_SUCCESS:
            return {...state, products: action.products};
        case FETCH_ERROR:
            return {...state, error: action.error};
        default:
            return state;
    }
};

export default productsReducer;
