import {
    FETCH_ERROR,
    FETCH_PRODUCTS_SUCCESS,
    GET_FULL_PRODUCT_SUCCESS
} from "../actionTypes";
import axios from "../../axios-api";
import {push} from "connected-react-router";
import {NotificationManager} from "react-notifications";


const fetchProductsSuccess = products => {
    return {type: FETCH_PRODUCTS_SUCCESS, products}
};

const getFullProductSuccess = product => {
    return {type: GET_FULL_PRODUCT_SUCCESS, product: product}
};

const fetchError = error => {
    return {type: FETCH_ERROR, error};
};

export const fetchProducts = (category) => {
    return dispatch => {
        if (category) {
            axios.get('/products?category=' + category)
                .then(res => {
                    dispatch(fetchProductsSuccess(res.data));
                })
                .catch(e => {
                    dispatch(fetchError(e));
                })

        } else {
            axios.get('/products')
                .then(res => {
                    dispatch(fetchProductsSuccess(res.data));
                })
                .catch(e => {
                    dispatch(fetchError(e));
                })
        }

    };
};


export const createProduct = product => {
    return (dispatch, getState) => {
        const token = getState().users.user.token;
        const headers = {Token: token};
        console.log(product)
        return axios.post("/products", product, {headers})
            .then(() => {
                dispatch(push('/'));
                NotificationManager.success("Created!");
            })
            .catch(e => {
                dispatch(fetchError(e));
            })
    };
};


