import React, {Component} from "react";
import {Button, Col, Form, FormGroup, Input, Label} from "reactstrap";
import {connect} from "react-redux";
import {history} from "../../store/configureStore";
import FormElement from "../../components/UI/FormElement/FormElement";
import {createProduct} from "../../store/actions/productsActions";
import {fetchCategories} from "../../store/actions/categoriesActions";

class AddProduct extends Component {

  state = {
    title: "",
    description: "",
    image: "",
    category: "",
    price: '1'
  };

  componentDidMount() {
    if (!this.props.user) {
      history.push('/login')
    }
    this.props.fetchCategories()
  }
  componentDidUpdate() {
    if(this.state.category === '') {
      this.setState({category: this.props.categories[0]._id})
    }
  }


  submitFormHandler = (e) => {
    const formData = new FormData();

    Object.keys(this.state).forEach(key => {
      formData.append(key, this.state[key]);
    });

    e.preventDefault();
    this.props.onProductCreated(formData)
  };


  inputChangeHandler = (e) => {
    this.setState({[e.target.name]: e.target.value});
  };

  fileChangeHandler = (e) => {
    this.setState({image: e.target.files[0]});
  };

  getIdByName = name => {
    for(let i = 0; i < this.props.categories.length; i++) {
      if(name === this.props.categories[i].title){
        return this.props.categories[i]._id;
      }
    }
    return name
  };

  selectChangeHandler = e => {
    this.setState({category: this.getIdByName(e.target.value)})
  };

  getFieldError = fieldName => {
    return this.props.error && this.props.error.errors && this.props.error.errors[fieldName] && this.props.error.errors[fieldName].message;
  };

  render() {
    return (
      <Form onSubmit={this.submitFormHandler}>
        <FormElement
          propertyName="title"
          label="Title"
          onChange={this.inputChangeHandler}
          value={this.state.title}
          required={true}
          type="text"
          placeholder="Enter post title"
          error={this.getFieldError("title")}
        />
        <FormElement
          propertyName="description"
          label="Description"
          onChange={this.inputChangeHandler}
          value={this.state.description}
          required={true}
          type="text"
          placeholder="Enter post description"
          error={this.getFieldError("description")}
        />

        <FormElement
          propertyName="image"
          label="Image"
          onChange={this.fileChangeHandler}
          required={true}
          type="file"
          error={this.getFieldError("image")}
        />

        <FormElement
          propertyName="price"
          label="Price"
          onChange={this.inputChangeHandler}
          value={this.state.price}
          required={true}
          min='1'
          type="number"
          error={this.getFieldError("price")}
        />


        <FormGroup row>
          <Label sm={2} for="category">Category</Label>
          <Col sm={10}>
            <Input onChange={this.selectChangeHandler} type="select" required name="category" id="category">
              {this.props.categories.map(category => {
                return (<option name={category._id} key={category._id}>{category.title}</option>)
              })}
            </Input>
          </Col>
        </FormGroup>
        <FormGroup row>
          <Col sm={{offset: 2, size: 10}}>
            <Button type="submit">Publish Post</Button>
          </Col>
        </FormGroup>
      </Form>
    );
  }
}

const mapStateToProps = state => {
  return {
    user: state.users.user,
    categories: state.categories.categories,
    error: state.products.error
  }
};

const mapDispatchToProps = dispatch => {
  return {
    onProductCreated: (product) => dispatch(createProduct(product)),
    fetchCategories: () => dispatch(fetchCategories())
  };
};

export default connect(mapStateToProps, mapDispatchToProps)(AddProduct);
